/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.data.region;

import de.z0rdak.yawp.api.commands.CommandConstants;
import de.z0rdak.yawp.commands.arguments.region.RegionArgumentType;
import de.z0rdak.yawp.constants.Constants;
import de.z0rdak.yawp.core.flag.BooleanFlag;
import de.z0rdak.yawp.core.flag.IFlag;
import de.z0rdak.yawp.core.flag.RegionFlag;
import de.z0rdak.yawp.core.region.GlobalRegion;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.data.region.DimensionRegionCache;
import de.z0rdak.yawp.handler.HandlerUtil;
import de.z0rdak.yawp.platform.Services;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_26;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4284;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.NotImplementedException;
import org.jetbrains.annotations.Nullable;

public class RegionDataManager
extends class_18 {
    private static final String DATA_NAME = "yawp-dimensions";
    public static MinecraftServer serverInstance;
    private static GlobalRegion globalRegion;
    private static RegionDataManager regionDataCache;
    private final Map<class_5321<class_1937>, DimensionRegionCache> dimCacheMap = new HashMap<class_5321<class_1937>, DimensionRegionCache>();
    private final Set<String> dimensionDataNames = new HashSet<String>();

    private RegionDataManager() {
    }

    public static void save() {
        Constants.LOGGER.debug(class_2561.method_48321((String)"data.nbt.dimensions.save", (String)"Save for RegionDataManager called. Attempting to save region data...").getString());
        regionDataCache.method_80();
    }

    public static Set<String> getDimensionDataNames() {
        return Collections.unmodifiableSet(RegionDataManager.regionDataCache.dimensionDataNames);
    }

    public static List<DimensionRegionCache> getDimensionCaches() {
        return Collections.unmodifiableList(new ArrayList<DimensionRegionCache>(RegionDataManager.regionDataCache.dimCacheMap.values()));
    }

    public static RegionDataManager get() {
        if (regionDataCache == null && serverInstance != null) {
            class_3218 overworld = serverInstance.method_30002();
            if (!overworld.field_9236) {
                class_26 storage = overworld.method_17983();
                class_18.class_8645 rdmt = new class_18.class_8645(RegionDataManager::new, RegionDataManager::load, class_4284.field_45079);
                regionDataCache = (RegionDataManager)storage.method_20786(rdmt, DATA_NAME);
            }
        }
        return regionDataCache;
    }

    public static void initServerInstance(MinecraftServer server) {
        serverInstance = server;
    }

    public static void loadRegionDataForWorld(MinecraftServer minecraftServer, class_3218 serverWorld) {
        try {
            if (serverInstance == null) {
                serverInstance = minecraftServer;
            }
            boolean isOverworld = serverWorld.method_27983().method_29177().equals((Object)class_3218.field_25179.method_29177());
            if (HandlerUtil.isServerSide((class_1937)serverWorld) && isOverworld) {
                class_26 storage = serverWorld.method_17983();
                class_18.class_8645 rdmt = new class_18.class_8645(RegionDataManager::new, RegionDataManager::load, class_4284.field_45079);
                RegionDataManager data = (RegionDataManager)storage.method_17924(rdmt, DATA_NAME);
                storage.method_123(DATA_NAME, (class_18)data);
                regionDataCache = data;
                Constants.LOGGER.info(class_2561.method_48322((String)"data.nbt.dimensions.load.success", (String)"Loaded %s region(s) for %s dimension(s)", (Object[])new Object[]{data.getTotalRegionAmount(), data.getDimensionAmount()}).getString());
            }
        }
        catch (NullPointerException npe) {
            Constants.LOGGER.error(class_2561.method_48321((String)"data.nbt.dimensions.load.failure", (String)"Loading regions failed!").getString());
        }
    }

    public static RegionDataManager load(class_2487 nbt, class_7225.class_7874 registries) {
        RegionDataManager rdm = new RegionDataManager();
        rdm.dimCacheMap.clear();
        if (!nbt.method_10545("global") || nbt.method_10562("global").method_33133()) {
            Constants.LOGGER.info(class_2561.method_43471((String)"Missing global region data. Initializing new data. (Ignore this for the first server start)").getString());
            globalRegion = new GlobalRegion();
        } else {
            class_2487 globalNbt = nbt.method_10562("global");
            globalRegion = new GlobalRegion();
            globalRegion.deserializeNBT(globalNbt);
            Constants.LOGGER.info(class_2561.method_43471((String)"Loaded global region data").getString());
        }
        if (!nbt.method_10545("dimensions") || nbt.method_10562("dimensions").method_33133()) {
            Constants.LOGGER.info(class_2561.method_43471((String)"No region data found for dimensions. Initializing new data...").getString());
            rdm.dimCacheMap.clear();
        } else {
            class_2487 dimensionRegions = nbt.method_10562("dimensions");
            Constants.LOGGER.info(class_2561.method_43471((String)("Loading region(s) for " + dimensionRegions.method_10546() + " dimension(s)")).getString());
            rdm.dimCacheMap.clear();
            for (String dimKey2 : dimensionRegions.method_10541()) {
                if (!dimensionRegions.method_10573(dimKey2, 10)) continue;
                class_5321 dimension = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60654((String)dimKey2));
                class_2487 dimCacheNbt = dimensionRegions.method_10562(dimKey2);
                if (dimCacheNbt.method_10573("regions", 10)) {
                    Constants.LOGGER.info(class_2561.method_43471((String)("Loading " + dimCacheNbt.method_10562("regions").method_10546() + " region(s) for dimension '" + dimKey2 + "'")).getString());
                } else {
                    Constants.LOGGER.info(class_2561.method_43471((String)("No region data for dimension '" + dimKey2 + "' found")).getString());
                }
                DimensionRegionCache dimCache = new DimensionRegionCache(dimCacheNbt);
                globalRegion.addChild(dimCache.getDimensionalRegion());
                rdm.dimCacheMap.put((class_5321<class_1937>)dimension, dimCache);
                rdm.dimensionDataNames.add(dimKey2);
                Constants.LOGGER.info(class_2561.method_48322((String)"data.nbt.dimensions.loaded.dim.amount", (String)"Loaded %s region(s) for dimension '%s'", (Object[])new Object[]{dimCache.getRegionCount(), dimCache.getDimensionalRegion().getName()}).getString());
            }
        }
        rdm.dimCacheMap.forEach((dimKey, cache) -> {
            if (cache.getRegionCount() > 0) {
                Constants.LOGGER.info(class_2561.method_43471((String)("Restoring region hierarchy for regions in dimension '" + String.valueOf(dimKey.method_29177()) + "'")).getString());
                ArrayList<IMarkableRegion> regions = new ArrayList<IMarkableRegion>(cache.getRegionsInDimension().values());
                regions.forEach(region -> region.getChildrenNames().forEach(childName -> {
                    if (!cache.contains((String)childName)) {
                        Constants.LOGGER.error(class_2561.method_43471((String)("Corrupt save data. Child region '" + childName + "' not found in dimension '" + String.valueOf(dimKey) + "'!")).getString());
                    } else {
                        IMarkableRegion child = cache.getRegion((String)childName);
                        if (child != null) {
                            cache.getDimensionalRegion().removeChild(child);
                            region.addChild(child);
                        }
                    }
                }));
            }
        });
        return rdm;
    }

    public static void addDimKeyOnDimensionChange(class_1657 Player, class_1937 origin, class_1937 destination) {
        if (HandlerUtil.isServerSide(destination) && !RegionDataManager.regionDataCache.dimCacheMap.containsKey(destination.method_27983())) {
            DimensionRegionCache cache = RegionDataManager.get().newCacheFor((class_5321<class_1937>)destination.method_27983());
            Constants.LOGGER.info("Init region data for dimension '{}'..", (Object)cache.dimensionKey().method_29177());
            RegionDataManager.save();
        }
    }

    public static void addDimKeyOnPlayerLogin(class_1297 entity, class_1937 serverWorld) {
        class_5321 dim;
        if (HandlerUtil.isServerSide(serverWorld) && entity instanceof class_1657 && !RegionDataManager.regionDataCache.dimCacheMap.containsKey(dim = serverWorld.method_27983())) {
            DimensionRegionCache cache = regionDataCache.newCacheFor((class_5321<class_1937>)dim);
            Constants.LOGGER.info("Player joining to server in dimension without region data. This should only happen the first time a player is joining.");
            Constants.LOGGER.info("Init region data for dimension '{}'..", (Object)cache.dimensionKey().method_29177());
            RegionDataManager.save();
        }
    }

    public static void addFlags(Set<String> flags, IProtectedRegion region) {
        flags.stream().map(RegionFlag::fromId).forEach(flag -> {
            switch (flag.type) {
                case BOOLEAN_FLAG: {
                    region.addFlag(new BooleanFlag((RegionFlag)((Object)flag)));
                    break;
                }
                case LIST_FLAG: 
                case INT_FLAG: {
                    throw new NotImplementedException("");
                }
            }
        });
    }

    public class_2487 method_75(class_2487 compound, class_7225.class_7874 var2) {
        compound.method_10566("global", (class_2520)globalRegion.serializeNBT());
        class_2487 dimRegionNbtData = new class_2487();
        Constants.LOGGER.info(class_2561.method_43471((String)("Saving " + this.getTotalRegionAmount() + " region(s) for " + this.dimCacheMap.keySet().size() + " dimensions")).getString());
        for (Map.Entry<class_5321<class_1937>, DimensionRegionCache> entry : this.dimCacheMap.entrySet()) {
            Constants.LOGGER.info(class_2561.method_43471((String)("Saving " + this.getRegionAmount(entry.getKey()) + " region(s) for dimension '" + String.valueOf(entry.getKey().method_29177()) + "'")).getString());
            String dimensionName = entry.getValue().getDimensionalRegion().getName();
            dimRegionNbtData.method_10566(dimensionName, (class_2520)entry.getValue().serializeNBT());
        }
        compound.method_10566("dimensions", (class_2520)dimRegionNbtData);
        return compound;
    }

    public int getTotalRegionAmount() {
        return this.dimCacheMap.values().stream().mapToInt(DimensionRegionCache::getRegionCount).sum();
    }

    public int getRegionAmount(class_5321<class_1937> dim) {
        return this.cacheFor(dim).getRegionCount();
    }

    public Set<String> getDimensionList() {
        return this.dimCacheMap.keySet().stream().map(entry -> entry.method_29177().toString()).collect(Collectors.toSet());
    }

    public Set<class_5321<class_1937>> getDimKeys() {
        return new HashSet<class_5321<class_1937>>(this.dimCacheMap.keySet());
    }

    public GlobalRegion getGlobalRegion() {
        return globalRegion;
    }

    public void resetDimensionCache(class_5321<class_1937> dim) {
        this.dimCacheMap.remove(dim);
    }

    public void resetGlobalRegion() {
        ArrayList<IProtectedRegion> collect = new ArrayList<IProtectedRegion>(globalRegion.getChildren().values());
        globalRegion = new GlobalRegion();
        collect.forEach(dr -> globalRegion.addChild((IProtectedRegion)dr));
        RegionDataManager.save();
    }

    public int getDimensionAmount() {
        return this.dimCacheMap.keySet().size();
    }

    @Nullable
    public Optional<IMarkableRegion> getRegionIn(class_5321<class_1937> dim, String regionName) {
        DimensionRegionCache cache;
        if (this.dimCacheMap.containsKey(dim) && (cache = this.dimCacheMap.get(dim)).contains(regionName)) {
            IMarkableRegion region = cache.getRegion(regionName);
            return region == null ? Optional.empty() : Optional.of(region);
        }
        return Optional.empty();
    }

    public Collection<IMarkableRegion> getRegionsFor(class_5321<class_1937> dim) {
        return this.cacheFor(dim).getAllLocal();
    }

    public DimensionRegionCache cacheFor(class_5321<class_1937> dim) {
        if (!this.dimCacheMap.containsKey(dim)) {
            this.newCacheFor(dim);
            RegionDataManager.save();
        }
        return this.dimCacheMap.get(dim);
    }

    public Optional<DimensionRegionCache> getCache(class_5321<class_1937> dim) {
        if (!this.dimCacheMap.containsKey(dim)) {
            return Optional.empty();
        }
        return Optional.of(this.dimCacheMap.get(dim));
    }

    public int isValidRegionName(class_5321<class_1937> dim, String regionName) {
        List commandStrings = Arrays.stream(CommandConstants.values()).map(CommandConstants::toString).collect(Collectors.toList());
        if (!regionName.matches(RegionArgumentType.VALID_NAME_PATTERN.pattern()) || commandStrings.contains(regionName.toLowerCase())) {
            return -1;
        }
        if (this.cacheFor(dim).contains(regionName)) {
            return 1;
        }
        return 0;
    }

    public boolean isAvailableForLocal(class_5321<class_1937> dim, String regionName) {
        if (this.cacheFor(dim).contains(regionName)) {
            return false;
        }
        return this.isValidRegionName(dim, regionName) == 0;
    }

    public boolean containsCacheFor(class_5321<class_1937> dim) {
        return this.dimCacheMap.containsKey(dim);
    }

    public List<String> getFlagsIdsForDim(DimensionRegionCache dimCache) {
        if (dimCache != null) {
            return dimCache.getDimensionalRegion().getFlags().flags().stream().map(IFlag::getName).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    public DimensionRegionCache newCacheFor(class_5321<class_1937> dim) {
        DimensionRegionCache cache = new DimensionRegionCache(dim);
        Set<String> defaultDimFlags = Services.REGION_CONFIG.getDefaultDimFlags();
        RegionDataManager.addFlags(defaultDimFlags, cache.getDimensionalRegion());
        cache.getDimensionalRegion().setIsActive(Services.REGION_CONFIG.shouldActivateNewDimRegion());
        globalRegion.addChild(cache.getDimensionalRegion());
        this.dimCacheMap.put(dim, cache);
        this.dimensionDataNames.add(cache.getDimensionalRegion().getName());
        return cache;
    }

    static {
        globalRegion = new GlobalRegion();
        regionDataCache = new RegionDataManager();
    }
}

